﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x0200004E RID: 78
	[DesignerGenerated]
	public partial class Form9 : Form
	{
		// Token: 0x06000308 RID: 776 RVA: 0x00019B68 File Offset: 0x00017D68
		public Form9()
		{
			base.Load += this.Form9_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x170000E5 RID: 229
		// (get) Token: 0x0600030B RID: 779 RVA: 0x00003968 File Offset: 0x00001B68
		// (set) Token: 0x0600030C RID: 780 RVA: 0x0001A7DC File Offset: 0x000189DC
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x170000E6 RID: 230
		// (get) Token: 0x0600030D RID: 781 RVA: 0x00003972 File Offset: 0x00001B72
		// (set) Token: 0x0600030E RID: 782 RVA: 0x0001A820 File Offset: 0x00018A20
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x170000E7 RID: 231
		// (get) Token: 0x0600030F RID: 783 RVA: 0x0000397C File Offset: 0x00001B7C
		// (set) Token: 0x06000310 RID: 784 RVA: 0x00003986 File Offset: 0x00001B86
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000E8 RID: 232
		// (get) Token: 0x06000311 RID: 785 RVA: 0x0000398F File Offset: 0x00001B8F
		// (set) Token: 0x06000312 RID: 786 RVA: 0x00003999 File Offset: 0x00001B99
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000E9 RID: 233
		// (get) Token: 0x06000313 RID: 787 RVA: 0x000039A2 File Offset: 0x00001BA2
		// (set) Token: 0x06000314 RID: 788 RVA: 0x000039AC File Offset: 0x00001BAC
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000EA RID: 234
		// (get) Token: 0x06000315 RID: 789 RVA: 0x000039B5 File Offset: 0x00001BB5
		// (set) Token: 0x06000316 RID: 790 RVA: 0x000039BF File Offset: 0x00001BBF
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000EB RID: 235
		// (get) Token: 0x06000317 RID: 791 RVA: 0x000039C8 File Offset: 0x00001BC8
		// (set) Token: 0x06000318 RID: 792 RVA: 0x000039D2 File Offset: 0x00001BD2
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000EC RID: 236
		// (get) Token: 0x06000319 RID: 793 RVA: 0x000039DB File Offset: 0x00001BDB
		// (set) Token: 0x0600031A RID: 794 RVA: 0x000039E5 File Offset: 0x00001BE5
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000ED RID: 237
		// (get) Token: 0x0600031B RID: 795 RVA: 0x000039EE File Offset: 0x00001BEE
		// (set) Token: 0x0600031C RID: 796 RVA: 0x000039F8 File Offset: 0x00001BF8
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x0600031D RID: 797 RVA: 0x0001A864 File Offset: 0x00018A64
		private void Form9_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x0600031E RID: 798 RVA: 0x0001A8EC File Offset: 0x00018AEC
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x0600031F RID: 799 RVA: 0x0001A914 File Offset: 0x00018B14
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x06000320 RID: 800 RVA: 0x0001A980 File Offset: 0x00018B80
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x06000321 RID: 801 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x06000322 RID: 802 RVA: 0x00003A01 File Offset: 0x00001C01
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x06000323 RID: 803 RVA: 0x0001AAD0 File Offset: 0x00018CD0
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form9._Closure$__53-0 CS$<>8__locals1 = new Form9._Closure$__53-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool @checked = this.EthCheckBox.Checked;
				if (@checked)
				{
					CS$<>8__locals1.$VB$Local_selectedCrypto = "BTC";
					bool validCrypto = false;
					bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
					if (flag2)
					{
						validCrypto = true;
						this.isMining = true;
						this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
						await Task.Run(checked(delegate()
						{
							int num = 0;
							while (!CS$<>8__locals1.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
							{
								bool flag3 = CS$<>8__locals1.$VB$Me.tries > CS$<>8__locals1.$VB$Me.random.Next(1500, 1000000000);
								if (flag3)
								{
									string text = Form9.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									bool flag4 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0;
									List<string> list;
									int num3;
									unchecked
									{
										if (flag4)
										{
											double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
										}
										else
										{
											bool flag5 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
											if (flag5)
											{
												double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
											}
										}
										list = new List<string>();
										num3 = 0;
									}
									do
									{
										bool flag6 = num3 < CS$<>8__locals1.$VB$Me.words.Length;
										if (flag6)
										{
											list.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										}
										num3++;
									}
									while (num3 <= 11);
									string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
									text2 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.tries = 0;
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
									Thread.Sleep(1);
								}
								else
								{
									string text3 = Form9.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									List<string> list2 = new List<string>();
									int num4 = 0;
									do
									{
										list2.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										num4++;
									}
									while (num4 <= 11);
									string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
									text4 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
									Form9 $VB$Me = CS$<>8__locals1.$VB$Me;
									ref int ptr = ref $VB$Me.tries;
									$VB$Me.tries = ptr + 1;
									num++;
								}
							}
						}));
					}
					if (!validCrypto)
					{
						MessageBox.Show("Please choose a valid currency (ETH or BTC).", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
					}
				}
				else
				{
					MessageBox.Show("Please select all blockchains.", "Invalid Blockchain", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x06000324 RID: 804 RVA: 0x0001A914 File Offset: 0x00018B14
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x06000325 RID: 805 RVA: 0x0001AB18 File Offset: 0x00018D18
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x04000254 RID: 596
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x04000255 RID: 597
		private Random random;

		// Token: 0x04000256 RID: 598
		private int tries;

		// Token: 0x04000257 RID: 599
		private bool isMining;

		// Token: 0x04000259 RID: 601
		private int foundCount;

		// Token: 0x0400025A RID: 602
		private string[] words;

		// Token: 0x0400025B RID: 603
		private StringBuilder textBuilder;
	}
}
